//=============================================================================
// DiarrhiaFragment.
//=============================================================================
class DiarrhiaFragment expands DeusExFragment;

#exec TEXTURE IMPORT NAME="GreenPoop" FILE="C:\DeusEx\MarkistanCity\Textures\GreenPoop.bmp" GROUP=Skins

auto state Flying
{
	function BeginState()
	{
		Super.BeginState();

		Velocity = VRand() * 300;
		DrawScale = FRand() + 1.5;
	}
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);
	
	if (!IsInState('Dying'))
		if (FRand() < 0.2)
			Spawn(class'BowelDrop',,, Location);
}

defaultproperties
{
     Fragments(0)=LodMesh'DeusExItems.FleshFragment1'
     Fragments(1)=LodMesh'DeusExItems.FleshFragment2'
     Fragments(2)=LodMesh'DeusExItems.FleshFragment3'
     Fragments(3)=LodMesh'DeusExItems.FleshFragment4'
     numFragmentTypes=4
     elasticity=0.400000
     ImpactSound=Sound'DeusExSounds.Generic.FleshHit1'
     MiscSound=Sound'DeusExSounds.Generic.FleshHit2'
     Mesh=LodMesh'DeusExItems.FleshFragment1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     Mass=5.000000
     Buoyancy=5.500000
     bVisionImportant=True
     MultiSkins(0)=Texture'GreenPoop'
     MultiSkins(1)=Texture'GreenPoop'
     MultiSkins(2)=Texture'GreenPoop'
     MultiSkins(3)=Texture'GreenPoop'
     MultiSkins(4)=Texture'GreenPoop'
     MultiSkins(5)=Texture'GreenPoop'
     MultiSkins(6)=Texture'GreenPoop'
     MultiSkins(7)=Texture'GreenPoop'
}
